/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.CrossingLampsTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public abstract class BlockLampBase
extends Block {
    public static final PropertyEnum<EnumState> STATE = PropertyEnum.func_177709_a((String)"state", EnumState.class);

    public BlockLampBase() {
        super(Material.field_151573_f);
        this.setRegistryName(this.getLampRegistryName());
        this.func_149663_c("trafficcontrol." + this.getLampRegistryName());
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    protected abstract String getLampRegistryName();

    public abstract IBlockState getStateForPlacement(World var1, BlockPos var2, EnumFacing var3, float var4, float var5, float var6, int var7, EntityLivingBase var8, EnumHand var9);

    public abstract IBlockState func_176203_a(int var1);

    public abstract int func_176201_c(IBlockState var1);

    public abstract IProperty<?> getRotationalProperty();

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new CrossingLampsTileEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getRotationalProperty(), STATE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        CrossingLampsTileEntity crossingLampsTE = null;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof CrossingLampsTileEntity)) {
            return state;
        }
        crossingLampsTE = (CrossingLampsTileEntity)te;
        EnumState flashState = EnumState.Off;
        if (crossingLampsTE != null) {
            flashState = crossingLampsTE.getState();
        }
        return state.func_177226_a(STATE, (Comparable)((Object)flashState));
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        CrossingLampsTileEntity crossingLampsTE = null;
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof CrossingLampsTileEntity)) {
            return 0;
        }
        crossingLampsTE = (CrossingLampsTileEntity)te;
        EnumState flashState = EnumState.Off;
        if (crossingLampsTE != null) {
            flashState = crossingLampsTE.getState();
        }
        if (flashState == EnumState.Flash1 || flashState == EnumState.Flash2) {
            return 15;
        }
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum EnumState implements IStringSerializable
    {
        Off(0, "off"),
        Flash1(1, "flash1"),
        Flash2(2, "flash2");

        private int id;
        private String name;

        private EnumState(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getID() {
            return this.id;
        }

        public static EnumState getStateByID(int id) {
            for (EnumState state : EnumState.values()) {
                if (state.id != id) continue;
                return state;
            }
            return null;
        }
    }
}

