/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModItems;
import com.clussmanproductions.trafficcontrol.ModSounds;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.PedestrianButtonTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.TrafficLightControlBoxTileEntity;
import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPedestrianButton
extends Block {
    public static PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    public static PropertyBool ABOVE = PropertyBool.func_177716_a((String)"above");

    public BlockPedestrianButton() {
        super(Material.field_151573_f);
        this.setRegistryName("pedestrian_button");
        this.func_149663_c("trafficcontrol.pedestrian_button");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, ABOVE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)ABOVE, (Comparable)Boolean.valueOf(!worldIn.func_175623_d(pos.func_177984_a())));
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int rotation = CustomAngleCalculator.getRotationForYaw(placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new PedestrianButtonTileEntity();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() != ModItems.crossing_relay_tuner) {
            worldIn.func_184133_a(null, pos, ModSounds.pedButton, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof PedestrianButtonTileEntity) {
            PedestrianButtonTileEntity pedTE = (PedestrianButtonTileEntity)te;
            for (BlockPos controller : pedTE.getPairedBoxes()) {
                TileEntity prelimCtrlrTE = worldIn.func_175625_s(controller);
                if (prelimCtrlrTE == null || !(prelimCtrlrTE instanceof TrafficLightControlBoxTileEntity)) {
                    pedTE.removePairedBox(controller);
                    continue;
                }
                TrafficLightControlBoxTileEntity ctrlr = (TrafficLightControlBoxTileEntity)prelimCtrlrTE;
                int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
                if (CustomAngleCalculator.isNorthSouth(rotation)) {
                    ctrlr.getAutomator().setWestEastPedQueued(true);
                    continue;
                }
                ctrlr.getAutomator().setNorthSouthPedQueued(true);
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            super.func_180663_b(worldIn, pos, state);
            return;
        }
        PedestrianButtonTileEntity te = (PedestrianButtonTileEntity)worldIn.func_175625_s(pos);
        if (te != null) {
            int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
            te.onBreak(worldIn, CustomAngleCalculator.isNorthSouth(rotation));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!(state.func_177230_c() instanceof BlockPedestrianButton)) {
            return field_185505_j;
        }
        int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
        switch (rotation) {
            case 0: {
                return new AxisAlignedBB(0.71875, 0.0, 0.4375, 0.28125, 0.625, 0.625);
            }
            case 8: {
                return new AxisAlignedBB(0.71875, 0.0, 0.375, 0.28125, 0.625, 0.5625);
            }
            case 4: {
                return new AxisAlignedBB(0.375, 0.0, 0.71875, 0.5625, 0.625, 0.28125);
            }
            case 12: {
                return new AxisAlignedBB(0.4375, 0.0, 0.71875, 0.625, 0.625, 0.28125);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.75, 1.0, 0.75);
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                return new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
            }
        }
        return field_185505_j;
    }
}

