/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.WigWagTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.render.RendererWigWag;
import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWigWag
extends Block
implements ITileEntityProvider {
    public static PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockWigWag() {
        super(Material.field_151573_f);
        this.setRegistryName("wig_wag");
        this.func_149663_c("trafficcontrol.wig_wag");
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(WigWagTileEntity.class, (TileEntitySpecialRenderer)new RendererWigWag());
    }

    public int func_176201_c(IBlockState state) {
        return CustomAngleCalculator.rotationToMeta((Integer)state.func_177229_b((IProperty)ROTATION));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(CustomAngleCalculator.metaToRotation(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, ACTIVE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        WigWagTileEntity wigWagTE = null;
        if (worldIn instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)worldIn;
            TileEntity te = chunkCache.func_175625_s(pos);
            if (!(te instanceof WigWagTileEntity)) {
                return super.func_176221_a(state, worldIn, pos);
            }
            wigWagTE = (WigWagTileEntity)te;
        } else {
            World world = (World)worldIn;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof WigWagTileEntity)) {
                return super.func_176221_a(state, worldIn, pos);
            }
            wigWagTE = (WigWagTileEntity)te;
        }
        return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(wigWagTE.isActive()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177230_c() != ModBlocks.wig_wag) {
            return field_185505_j;
        }
        int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
        switch (rotation) {
            case 0: {
                return new AxisAlignedBB(-0.375, 0.0, 0.625, 0.5625, 1.0, 0.375);
            }
            case 8: {
                return new AxisAlignedBB(0.4375, 0.0, 0.625, 1.375, 1.0, 0.375);
            }
            case 4: {
                return new AxisAlignedBB(0.375, 0.0, 0.5625, 0.625, 1.0, -0.375);
            }
            case 12: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.3125);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.75, 1.0, 0.75);
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                return new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
            }
        }
        return field_185505_j;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 15 : 0;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(CustomAngleCalculator.getRotationForYaw(placer.field_70177_z))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new WigWagTileEntity();
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }
}

