/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.gui;

import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GuiImageList {
    private int x;
    private int y;
    private int width;
    private int height;
    private String filter;
    private Consumer<SignTileEntity.Sign> imageClickCallback;
    private boolean didLoadFail = false;
    private String loadFailedMessage = null;
    private HashMap<String, SignTileEntity.Sign> imagesByName;
    SignTileEntity.Sign[][] slots;
    private int scrollBarLeft;
    private double scrollBarHeight;
    private double scrollBarTop;
    private int currentScrollBarStep = 0;
    private int maxScrollBarSteps = 0;
    private boolean isMouseClicked = false;
    private boolean isMouseHover = false;
    private int clickY = 0;
    private int preClickScrollBarStep = 0;
    private boolean isVisible = true;

    public GuiImageList(int x, int y, int width, int height, String filter, Consumer<SignTileEntity.Sign> imageClickCallback) {
        this.x = x + width % 16;
        this.y = y + height % 16;
        this.width = width - width % 16;
        this.height = height - height % 16;
        this.filter = filter;
        this.imageClickCallback = imageClickCallback;
        int slotWidth = width / 16 - 1;
        if (slotWidth < 1) {
            this.didLoadFail = true;
            this.loadFailedMessage = "Too narrow";
            return;
        }
        this.imagesByName = new HashMap();
        for (SignTileEntity.Sign sign : SignTileEntity.SIGNS_BY_TYPE_VARIANT.values()) {
            this.imagesByName.put(sign.getName() + " (" + sign.getVariant() + ")", sign);
        }
        this.fillSlots();
    }

    public GuiImageList(int x, int y, int width, int height, Consumer<SignTileEntity.Sign> imageClickCallback) {
        this(x, y, width, height, null, imageClickCallback);
    }

    public void draw(int mouseX, int mouseY, FontRenderer renderer, Function<List<String>, Function<Integer, Consumer<Integer>>> drawHoveringTextCallback) {
        if (!this.isVisible()) {
            return;
        }
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        if (this.didLoadFail) {
            int length = renderer.func_78256_a(this.loadFailedMessage);
            int left = this.x + (this.width / 2 - length / 2);
            renderer.func_78276_b(this.loadFailedMessage, left, this.y + this.height / 2, 0xFFFFFF);
            return;
        }
        if (this.isMouseClicked) {
            int differenceY = mouseY - this.clickY;
            this.currentScrollBarStep = this.preClickScrollBarStep + (int)((double)differenceY / this.scrollBarHeight);
            if (this.currentScrollBarStep > this.maxScrollBarSteps) {
                this.currentScrollBarStep = this.maxScrollBarSteps;
            }
            if (this.currentScrollBarStep < 0) {
                this.currentScrollBarStep = 0;
            }
            this.scrollBarTop = (double)this.y + this.scrollBarHeight * (double)this.currentScrollBarStep;
        }
        GlStateManager.func_179090_x();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)(this.x + this.width - 16), (double)(this.y + this.height), 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)(this.x + this.width - 16), (double)this.y, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)this.x, (double)this.y, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        builder.func_181662_b((double)this.x, (double)(this.y + this.height), 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        int renderableRows = this.height / 16;
        int maxRows = this.imagesByName.keySet().size() / this.slots.length + 1;
        SignTileEntity.Sign hoveringImage = null;
        if (mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height) {
            this.isMouseHover = true;
            int hoverCol = (mouseX - this.x) / 16;
            int hoverRow = (mouseY - this.y) / 16;
            if (hoverRow < renderableRows && this.slots.length > hoverCol && this.slots[hoverCol].length - this.currentScrollBarStep > hoverRow && this.slots[hoverCol][hoverRow + this.currentScrollBarStep] != null && (hoveringImage = this.slots[hoverCol][hoverRow + this.currentScrollBarStep]) != null) {
                int hoverColX = this.x + hoverCol * 16;
                int hoverRowY = this.y + hoverRow * 16;
                builder.func_181662_b((double)(hoverColX + 16), (double)(hoverRowY + 16), 0.0).func_181669_b(0, 0, 255, 255).func_181675_d();
                builder.func_181662_b((double)(hoverColX + 16), (double)hoverRowY, 0.0).func_181669_b(0, 0, 255, 255).func_181675_d();
                builder.func_181662_b((double)hoverColX, (double)hoverRowY, 0.0).func_181669_b(0, 0, 255, 255).func_181675_d();
                builder.func_181662_b((double)hoverColX, (double)(hoverRowY + 16), 0.0).func_181669_b(0, 0, 255, 255).func_181675_d();
            }
        } else {
            this.isMouseHover = false;
        }
        this.drawScrollbar(mouseX, mouseY, renderableRows, maxRows);
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        for (int col = 0; col < this.slots.length; ++col) {
            int rowLimit = this.slots[col].length - this.currentScrollBarStep < renderableRows ? this.slots[col].length - this.currentScrollBarStep : renderableRows;
            for (int row = 0; row < rowLimit; ++row) {
                SignTileEntity.Sign image = this.slots[col][row + this.currentScrollBarStep];
                if (image == null) continue;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(image.getImageResourceLocation());
                int imageX = this.x + col * 16;
                int imageY = this.y + row * 16;
                builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                builder.func_181662_b((double)(imageX + 16), (double)(imageY + 16), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                builder.func_181662_b((double)(imageX + 16), (double)imageY, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                builder.func_181662_b((double)imageX, (double)imageY, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                builder.func_181662_b((double)imageX, (double)(imageY + 16), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                tess.func_78381_a();
            }
        }
        if (hoveringImage != null) {
            ArrayList<String> hoverText = new ArrayList<String>();
            hoverText.add("\u00a7e" + hoveringImage.getName() + " (" + hoveringImage.getVariant() + ")");
            if (hoveringImage.getToolTip() != null && hoveringImage.getToolTip() != "") {
                hoverText.add(hoveringImage.getToolTip());
            }
            drawHoveringTextCallback.apply(hoverText).apply(mouseX).accept(mouseY);
        }
    }

    public void scroll(int direction) {
        if (!this.isMouseHover) {
            return;
        }
        if (direction == 1) {
            this.scrollUp();
        } else if (direction == -1) {
            this.scrollDown();
        }
    }

    private void scrollUp() {
        --this.currentScrollBarStep;
        if (this.currentScrollBarStep < 0) {
            this.currentScrollBarStep = 0;
        } else {
            this.scrollBarTop -= this.scrollBarHeight;
        }
    }

    public void scrollDown() {
        ++this.currentScrollBarStep;
        if (this.currentScrollBarStep > this.maxScrollBarSteps) {
            this.currentScrollBarStep = this.maxScrollBarSteps;
        } else {
            this.scrollBarTop += this.scrollBarHeight;
        }
    }

    public void drawScrollbar(int mouseX, int mouseY, int renderableRows, int maxRows) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181662_b((double)this.scrollBarLeft, (double)this.y, 1.0).func_181669_b(32, 32, 32, 255).func_181675_d();
        builder.func_181662_b((double)this.scrollBarLeft, (double)(this.y + this.height), 1.0).func_181669_b(32, 32, 32, 255).func_181675_d();
        builder.func_181662_b((double)(this.x + this.width), (double)(this.y + this.height), 1.0).func_181669_b(32, 32, 32, 255).func_181675_d();
        builder.func_181662_b((double)(this.x + this.width), (double)this.y, 1.0).func_181669_b(32, 32, 32, 255).func_181675_d();
        builder.func_181662_b((double)this.scrollBarLeft, this.scrollBarTop, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
        builder.func_181662_b((double)this.scrollBarLeft, this.scrollBarTop + this.scrollBarHeight, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
        builder.func_181662_b((double)(this.x + this.width), this.scrollBarTop + this.scrollBarHeight, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
        builder.func_181662_b((double)(this.x + this.width), this.scrollBarTop, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
    }

    public void onMouseClick(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        if (mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height) {
            if (mouseX > this.scrollBarLeft && (double)mouseY > this.scrollBarTop && (double)mouseY < this.scrollBarTop + this.scrollBarHeight) {
                this.isMouseClicked = true;
                this.clickY = mouseY;
                this.preClickScrollBarStep = this.currentScrollBarStep;
                return;
            }
            int hoverCol = (mouseX - this.x) / 16;
            int hoverRow = (mouseY - this.y) / 16;
            if (hoverCol < this.slots.length && hoverRow + this.currentScrollBarStep < this.slots[hoverCol].length) {
                SignTileEntity.Sign image = this.slots[hoverCol][hoverRow + this.currentScrollBarStep];
                if (image == null) {
                    return;
                }
                if (this.imageClickCallback != null) {
                    this.imageClickCallback.accept(image);
                }
            }
        }
    }

    public void onMouseRelease() {
        this.isMouseClicked = false;
    }

    public void filter(String filterText) {
        this.filter = filterText;
        this.fillSlots();
    }

    private void fillSlots() {
        int slotWidth = this.width / 16 - 1;
        if (slotWidth < 1) {
            return;
        }
        Map<String, SignTileEntity.Sign> imagesToRender = this.imagesByName.entrySet().stream().filter((? super T entry) -> this.filter != null && this.filter.length() != 0 ? ((String)entry.getKey()).toLowerCase().contains(this.filter.toLowerCase()) : true).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (SignTileEntity.Sign)entry.getValue()));
        int rows = (imagesToRender.values().size() + 1) / slotWidth + 1;
        this.slots = new SignTileEntity.Sign[slotWidth][rows];
        int currentRow = 0;
        int currentCol = 0;
        for (Tuple signEntry : SignTileEntity.SIGNS_BY_TYPE_VARIANT.keySet().stream().sorted(new SignTileEntity.Sign.TestComparator()).collect(Collectors.toList())) {
            SignTileEntity.Sign image = (SignTileEntity.Sign)SignTileEntity.SIGNS_BY_TYPE_VARIANT.get((Object)signEntry);
            if (!imagesToRender.containsValue(image)) continue;
            this.slots[currentCol][currentRow] = image;
            if (++currentCol < slotWidth) continue;
            currentCol = 0;
            ++currentRow;
        }
        this.scrollBarLeft = this.x + this.width - 16;
        this.scrollBarTop = this.y;
        this.currentScrollBarStep = 0;
        this.maxScrollBarSteps = rows - this.height / 16;
        if (this.maxScrollBarSteps < 0) {
            this.maxScrollBarSteps = 0;
        }
        if (this.maxScrollBarSteps == 0) {
            this.scrollBarHeight = this.height;
        } else {
            this.scrollBarHeight = (double)this.height / ((double)this.maxScrollBarSteps + 1.0);
            if (this.scrollBarHeight > (double)this.height) {
                this.scrollBarHeight = this.height;
            }
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

