/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.gui;

import com.clussmanproductions.trafficcontrol.gui.GuiButtonExtSelectable;
import com.clussmanproductions.trafficcontrol.gui.GuiButtonExtSelectableImage;
import com.clussmanproductions.trafficcontrol.tileentity.StreetSign;
import com.clussmanproductions.trafficcontrol.tileentity.StreetSignTileEntity;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class StreetSignGui
extends GuiScreen {
    private StreetSignTileEntity te;

    public StreetSignGui(StreetSignTileEntity te) {
        this.te = te;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int horizontalCenter = this.field_146294_l / 2;
        int verticalCenter = this.field_146295_m / 2;
        ResourceLocation image = new ResourceLocation("trafficcontrol:textures/blocks/street_sign.png");
        for (int i = 0; i < 4; ++i) {
            StreetSign sign = this.te.getStreetSign(i);
            if (sign == null) continue;
            int baseID = 10 * i;
            int yOffset = (1 + -i) * 80;
            GuiButtonExt directionButton = new GuiButtonExt(baseID, horizontalCenter + 128 + 4, verticalCenter + yOffset, 70, 20, this.getDirectionText(sign));
            this.field_146292_n.add(directionButton);
            GuiButtonExtSelectableImage greenSignButton = new GuiButtonExtSelectableImage(baseID + 1, horizontalCenter + 128 + 4 + 70 + 4, verticalCenter + yOffset, 40, 20, image, StreetSign.StreetSignColors.Green.getCol(), (double)(StreetSign.StreetSignColors.Green.getRow() - 1) * 0.25, 1.0, 0.25);
            greenSignButton.setIsSelected(sign.getColor() == StreetSign.StreetSignColors.Green);
            this.field_146292_n.add(greenSignButton);
            GuiButtonExtSelectableImage redSignButton = new GuiButtonExtSelectableImage(baseID + 2, horizontalCenter + 128 + 4 + 70 + 4, verticalCenter + yOffset + 20 + 4, 40, 20, image, StreetSign.StreetSignColors.Red.getCol(), (double)(StreetSign.StreetSignColors.Red.getRow() - 1) * 0.25, 1.0, 0.25);
            redSignButton.setIsSelected(sign.getColor() == StreetSign.StreetSignColors.Red);
            this.field_146292_n.add(redSignButton);
            GuiButtonExtSelectableImage blueSignButton = new GuiButtonExtSelectableImage(baseID + 3, horizontalCenter + 128 + 4 + 70 + 4 + 40 + 4, verticalCenter + yOffset, 40, 20, image, StreetSign.StreetSignColors.Blue.getCol(), (double)(StreetSign.StreetSignColors.Blue.getRow() - 1) * 0.25, 1.0, 0.25);
            blueSignButton.setIsSelected(sign.getColor() == StreetSign.StreetSignColors.Blue);
            this.field_146292_n.add(blueSignButton);
            GuiButtonExtSelectableImage yellowSignButton = new GuiButtonExtSelectableImage(baseID + 4, horizontalCenter + 128 + 4 + 70 + 4 + 40 + 4, verticalCenter + yOffset + 20 + 4, 40, 20, image, StreetSign.StreetSignColors.Yellow.getCol(), (double)(StreetSign.StreetSignColors.Yellow.getRow() - 1) * 0.25, 1.0, 0.25);
            yellowSignButton.setIsSelected(sign.getColor() == StreetSign.StreetSignColors.Yellow);
            this.field_146292_n.add(yellowSignButton);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int horizontalCenter = this.field_146294_l / 2;
        int verticalCenter = this.field_146295_m / 2;
        for (int i = 0; i < 4; ++i) {
            StreetSign sign = this.te.getStreetSign(i);
            if (sign == null) continue;
            int yTexOffset = (sign.getColor().getRow() - 1) * 64;
            int yOffset = (1 + -i) * 80;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("trafficcontrol:textures/blocks/street_sign.png"));
            StreetSignGui.func_146110_a((int)(horizontalCenter - 128), (int)(verticalCenter + yOffset), (float)0.0f, (float)yTexOffset, (int)256, (int)64, (float)256.0f, (float)256.0f);
            GlStateManager.func_179109_b((float)horizontalCenter, (float)(verticalCenter + yOffset + 18), (float)0.0f);
            int width = this.field_146289_q.func_78256_a(sign.getText());
            double scaleFactor = 240.0 / (double)width;
            if (scaleFactor > 4.0) {
                scaleFactor = 4.0;
            }
            GlStateManager.func_179139_a((double)scaleFactor, (double)4.0, (double)4.0);
            int afterFontX = this.field_146289_q.func_78276_b(sign.getText(), -(width / 2), 0, sign.getTextColor());
            if (sign.getIsNew()) {
                this.field_146289_q.func_78276_b("_", afterFontX, 0, sign.getTextColor());
            }
            GlStateManager.func_179139_a((double)(1.0 / scaleFactor), (double)0.25, (double)4.0);
            GlStateManager.func_179109_b((float)(-horizontalCenter), (float)(-(verticalCenter + yOffset + 18)), (float)0.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        StreetSign currentSign = null;
        for (int i = 0; i < 4; ++i) {
            StreetSign testSign = this.te.getStreetSign(i);
            if (testSign == null || !testSign.getIsNew()) continue;
            currentSign = testSign;
            break;
        }
        if (currentSign == null) {
            super.func_73869_a(typedChar, keyCode);
            return;
        }
        if (keyCode == 14 && currentSign.getText().length() > 0) {
            currentSign.setText(currentSign.getText().substring(0, currentSign.getText().length() - 1));
            return;
        }
        if (Character.isLetterOrDigit(typedChar) || Character.isSpaceChar(typedChar) || Arrays.stream(new Character[]{Character.valueOf('.'), Character.valueOf(','), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('/'), Character.valueOf('`'), Character.valueOf('~')}).anyMatch(c -> c.equals(new Character(typedChar)))) {
            currentSign.setText(currentSign.getText() + typedChar);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton != 1) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            return;
        }
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            guibutton.func_146113_a(this.field_146297_k.func_147118_V());
            this.onButtonRightClick(guibutton);
        }
    }

    private void onButtonRightClick(GuiButton button) {
        int buttonID;
        GuiButtonExt extButton = (GuiButtonExt)button;
        int signIndex = 0;
        for (buttonID = button.field_146127_k; buttonID >= 10; buttonID -= 10) {
            ++signIndex;
        }
        if (buttonID != 0) {
            return;
        }
        StreetSign sign = this.te.getStreetSign(signIndex);
        if (sign == null) {
            return;
        }
        this.decrementRotation(sign);
        extButton.field_146126_j = this.getDirectionText(sign);
    }

    public void func_146281_b() {
        for (int i = 0; i < 4; ++i) {
            StreetSign sign = this.te.getStreetSign(i);
            if (sign == null) continue;
            sign.setIsNew(false);
        }
        this.te.performClientToServerSync();
        super.func_146281_b();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int buttonID;
        GuiButtonExt extButton = (GuiButtonExt)button;
        GuiButtonExtSelectable sButton = null;
        if (extButton instanceof GuiButtonExtSelectable) {
            sButton = (GuiButtonExtSelectable)extButton;
        }
        int signIndex = 0;
        for (buttonID = button.field_146127_k; buttonID >= 10; buttonID -= 10) {
            ++signIndex;
        }
        StreetSign sign = this.te.getStreetSign(signIndex);
        if (sign == null) {
            return;
        }
        switch (buttonID) {
            case 0: {
                this.incrementRotation(sign);
                extButton.field_146126_j = this.getDirectionText(sign);
                break;
            }
            case 1: {
                this.clearAllColorSelections(signIndex);
                sButton.setIsSelected(true);
                sign.setColor(StreetSign.StreetSignColors.Green);
                break;
            }
            case 2: {
                this.clearAllColorSelections(signIndex);
                sButton.setIsSelected(true);
                sign.setColor(StreetSign.StreetSignColors.Red);
                break;
            }
            case 3: {
                this.clearAllColorSelections(signIndex);
                sButton.setIsSelected(true);
                sign.setColor(StreetSign.StreetSignColors.Blue);
                break;
            }
            case 4: {
                this.clearAllColorSelections(signIndex);
                sButton.setIsSelected(true);
                sign.setColor(StreetSign.StreetSignColors.Yellow);
            }
        }
    }

    private GuiButtonExtSelectable findButtonByID(int id) {
        Optional<GuiButton> button = this.field_146292_n.stream().filter(b -> b.field_146127_k == id).findFirst();
        return button.isPresent() ? (GuiButtonExtSelectable)button.get() : null;
    }

    private void clearAllColorSelections(int signIndex) {
        for (int i = 1; i <= 4; ++i) {
            this.findButtonByID(signIndex * 10 + i).setIsSelected(false);
        }
    }

    private String getDirectionText(StreetSign sign) {
        switch (sign.getRotation()) {
            case 0: 
            case 8: {
                return "N/S";
            }
            case 1: 
            case 9: {
                return "NNE/SSW";
            }
            case 2: 
            case 10: {
                return "NW/SE";
            }
            case 3: 
            case 11: {
                return "WNW/ESE";
            }
            case 4: 
            case 12: {
                return "W/E";
            }
            case 5: 
            case 13: {
                return "WSW/ENE";
            }
            case 6: 
            case 14: {
                return "SE/NW";
            }
            case 7: 
            case 15: {
                return "SSE/NNW";
            }
        }
        return "";
    }

    private void incrementRotation(StreetSign sign) {
        int currentRotation = sign.getRotation();
        if (currentRotation == 15) {
            currentRotation = -1;
        }
        sign.setRotation(++currentRotation);
    }

    private void decrementRotation(StreetSign sign) {
        int currentRotation = sign.getRotation();
        if (currentRotation == 0) {
            currentRotation = 16;
        }
        sign.setRotation(--currentRotation);
    }
}

