/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.scanner;

import java.util.List;
import java.util.UUID;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ScanRequest {
    private UUID requestID;
    private BlockPos startingPos;
    private List<BlockPos> endingPositions;
    private EnumFacing startDirection;

    public ScanRequest(UUID requestID, BlockPos startingPos, List<BlockPos> endingPositions, EnumFacing startDirection) {
        this.requestID = requestID;
        this.startingPos = startingPos;
        this.endingPositions = endingPositions;
        this.startDirection = startDirection;
    }

    public UUID getRequestID() {
        return this.requestID;
    }

    public BlockPos getStartingPos() {
        return this.startingPos;
    }

    public List<BlockPos> getEndingPositions() {
        return this.endingPositions;
    }

    public EnumFacing getStartDirection() {
        return this.startDirection;
    }

    public int hashCode() {
        int hashCode = 19;
        hashCode = 487 * hashCode + this.requestID.hashCode();
        hashCode = 487 * hashCode + this.startingPos.hashCode();
        hashCode = 487 * hashCode + this.endingPositions.hashCode();
        hashCode = 487 * hashCode + this.startDirection.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ScanRequest scanRequest = (ScanRequest)obj;
        if (scanRequest.endingPositions.size() != this.endingPositions.size()) {
            return false;
        }
        boolean listEquals = true;
        for (int i = 0; i < scanRequest.endingPositions.size(); ++i) {
            if (this.endingPositions.get(i).equals((Object)scanRequest.endingPositions.get(i))) continue;
            listEquals = false;
            break;
        }
        return this.requestID.equals(scanRequest.requestID) && this.startingPos.equals((Object)scanRequest.startingPos) && listEquals && this.startDirection.equals((Object)scanRequest.startDirection);
    }
}

