/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.scanner;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;

public class ScannerData
extends WorldSavedData {
    private HashSet<BlockPos> tileEntitySubscriptions = new HashSet();
    private ReentrantReadWriteLock tileEntitySubscriptionLock = new ReentrantReadWriteLock();

    public ScannerData(String mapName) {
        super(mapName);
    }

    public ScannerData() {
        super("TC_scanner_data");
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i = 0;
        ReentrantReadWriteLock.WriteLock lock = this.tileEntitySubscriptionLock.writeLock();
        lock.lock();
        while (nbt.func_74764_b("blockpos" + i)) {
            long serializedBlockPos = nbt.func_74763_f("blockpos" + i);
            this.tileEntitySubscriptions.add(BlockPos.func_177969_a((long)serializedBlockPos));
            ++i;
        }
        lock.unlock();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        int i = 0;
        ReentrantReadWriteLock.ReadLock lock = this.tileEntitySubscriptionLock.readLock();
        lock.lock();
        for (BlockPos pos : this.tileEntitySubscriptions) {
            compound.func_74772_a("blockpos" + i, pos.func_177986_g());
        }
        lock.unlock();
        return compound;
    }

    public ImmutableList<BlockPos> getSubscribers() {
        ReentrantReadWriteLock.ReadLock lock = this.tileEntitySubscriptionLock.readLock();
        lock.lock();
        ImmutableList list = ImmutableList.copyOf(this.tileEntitySubscriptions);
        lock.unlock();
        return list;
    }

    public void addSubscriber(BlockPos pos) {
        ReentrantReadWriteLock.WriteLock lock = this.tileEntitySubscriptionLock.writeLock();
        lock.lock();
        if (this.tileEntitySubscriptions.add(pos)) {
            this.func_76185_a();
        }
        lock.unlock();
    }

    public void removeSubscriber(BlockPos pos) {
        ReentrantReadWriteLock.WriteLock lock = this.tileEntitySubscriptionLock.writeLock();
        lock.lock();
        if (this.tileEntitySubscriptions.remove(pos)) {
            this.func_76185_a();
        }
        lock.unlock();
    }
}

