/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class StreetSign
implements INBTSerializable<NBTBase> {
    private int rotation = 0;
    private StreetSignColors color = StreetSignColors.Green;
    private String text = "";
    private boolean isNew = true;

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public StreetSignColors getColor() {
        return this.color;
    }

    public void setColor(StreetSignColors color) {
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public int getTextColor() {
        switch (this.getColor()) {
            case Yellow: {
                return 0;
            }
            case Blue: 
            case Green: 
            case Red: {
                return 0xFFFFFF;
            }
        }
        return 0xFFFFFF;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("rotation", CustomAngleCalculator.rotationToMeta(this.getRotation()));
        tag.func_74768_a("color", this.getColor().getIndex());
        tag.func_74778_a("text", this.getText());
        tag.func_74757_a("isNew", this.getIsNew());
        return tag;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        String rotationKey = compound.func_74764_b("facing") ? "facing" : "rotation";
        this.setRotation(CustomAngleCalculator.metaToRotation(compound.func_74762_e(rotationKey)));
        this.setColor(StreetSignColors.getByIndex(compound.func_74762_e("color")));
        this.setText(compound.func_74779_i("text"));
        this.setIsNew(compound.func_74767_n("isNew"));
    }

    public static enum StreetSignColors {
        Green(0, 1, 1),
        Red(1, 1, 2),
        Blue(2, 1, 3),
        Yellow(3, 1, 4);

        private int index;
        private int col;
        private int row;

        private StreetSignColors(int index, int col, int row) {
            this.index = index;
            this.col = col;
            this.row = row;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }

        public static StreetSignColors getByIndex(int index) {
            for (StreetSignColors color : StreetSignColors.values()) {
                if (color.getIndex() != index) continue;
                return color;
            }
            return null;
        }
    }
}

