/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.util;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.mod.entity.ModdedEntity;
import cam72cam.mod.math.Vec3d;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ImmersiveRailroadingHelper {
    public static net.minecraft.util.math.Vec3d findOrigin(BlockPos currentPos, EnumFacing signalFacing, World world) {
        net.minecraft.util.math.Vec3d retVal = new net.minecraft.util.math.Vec3d(0.0, -1.0, 0.0);
        cam72cam.mod.world.World camWorld = cam72cam.mod.world.World.get((World)world);
        EnumFacing searchDirection = signalFacing.func_176746_e().func_176746_e().func_176746_e();
        BlockPos workingPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() - 3, currentPos.func_177952_p());
        for (int y = 0; y < 6; ++y) {
            for (int i = 0; i <= 10; ++i) {
                Vec3d workingPosVec3d = new Vec3d((double)(workingPos = workingPos.func_177972_a(searchDirection)).func_177958_n(), (double)workingPos.func_177956_o(), (double)workingPos.func_177952_p());
                ITrack tile = ITrack.get((cam72cam.mod.world.World)camWorld, (Vec3d)workingPosVec3d, (boolean)false);
                if (tile == null) continue;
                Vec3d current = workingPosVec3d;
                Vec3d center = tile.getNextPosition(current, new Vec3d(0.0, 0.0, 0.0));
                retVal = new net.minecraft.util.math.Vec3d(center.x, center.y, center.z);
                break;
            }
            if (retVal.field_72448_b != -1.0) break;
            workingPos = new BlockPos(currentPos.func_177958_n(), currentPos.func_177956_o() + 1, currentPos.func_177952_p());
        }
        return retVal;
    }

    public static net.minecraft.util.math.Vec3d getNextPosition(net.minecraft.util.math.Vec3d currentPosition, net.minecraft.util.math.Vec3d motion, World world) {
        BlockPos currentBlockPos = new BlockPos(currentPosition.field_72450_a, currentPosition.field_72448_b, currentPosition.field_72449_c);
        cam72cam.mod.world.World camWorld = cam72cam.mod.world.World.get((World)world);
        ITrack te = ITrack.get((cam72cam.mod.world.World)camWorld, (Vec3d)new Vec3d((double)currentBlockPos.func_177958_n(), (double)currentBlockPos.func_177956_o(), (double)currentBlockPos.func_177952_p()), (boolean)false);
        for (int attempt = 0; te == null && attempt < 8; ++attempt) {
            switch (attempt) {
                case 0: {
                    currentBlockPos = currentBlockPos.func_177984_a();
                    break;
                }
                case 1: {
                    currentBlockPos = currentBlockPos.func_177979_c(2);
                    break;
                }
                case 2: {
                    currentBlockPos = currentBlockPos.func_177984_a();
                    EnumFacing direction = EnumFacing.func_176737_a((float)((float)motion.field_72450_a), (float)((float)motion.field_72448_b), (float)((float)motion.field_72449_c)).func_176746_e();
                    currentBlockPos = currentBlockPos.func_177972_a(direction);
                    break;
                }
                case 3: {
                    EnumFacing direction = EnumFacing.func_176737_a((float)((float)motion.field_72450_a), (float)((float)motion.field_72448_b), (float)((float)motion.field_72449_c)).func_176746_e().func_176746_e().func_176746_e();
                    currentBlockPos = currentBlockPos.func_177967_a(direction, 2);
                    break;
                }
                case 4: {
                    currentBlockPos = currentBlockPos.func_177984_a();
                    break;
                }
                case 5: {
                    currentBlockPos = currentBlockPos.func_177979_c(2);
                    break;
                }
                case 6: {
                    EnumFacing direction = EnumFacing.func_176737_a((float)((float)motion.field_72450_a), (float)((float)motion.field_72448_b), (float)((float)motion.field_72449_c)).func_176746_e();
                    currentBlockPos = currentBlockPos.func_177967_a(direction, 2);
                    break;
                }
                case 7: {
                    currentBlockPos = currentBlockPos.func_177981_b(2);
                }
            }
            te = ITrack.get((cam72cam.mod.world.World)camWorld, (Vec3d)new Vec3d((double)currentBlockPos.func_177958_n(), (double)currentBlockPos.func_177956_o(), (double)currentBlockPos.func_177952_p()), (boolean)false);
        }
        if (te == null) {
            return currentPosition;
        }
        Vec3d retVal = te.getNextPosition(new Vec3d(currentPosition), new Vec3d(motion));
        return retVal.internal();
    }

    public static Tuple<UUID, net.minecraft.util.math.Vec3d> getStockNearby(net.minecraft.util.math.Vec3d currentPosition, World world) {
        BlockPos currentBlockPos = new BlockPos(currentPosition.field_72450_a, currentPosition.field_72448_b, currentPosition.field_72449_c);
        AxisAlignedBB bb = new AxisAlignedBB(currentBlockPos.func_177977_b().func_177970_e(2).func_177985_f(2), currentBlockPos.func_177981_b(3).func_177965_g(2).func_177964_d(2));
        List stocks = ImmutableList.copyOf((Collection)world.field_72996_f).stream().map(x -> x instanceof ModdedEntity ? (ModdedEntity)x : null).filter(Objects::nonNull).map(x -> x.getSelf() instanceof EntityMoveableRollingStock ? (EntityMoveableRollingStock)x.getSelf() : null).filter(Objects::nonNull).filter(emrs -> bb.func_72318_a(new net.minecraft.util.math.Vec3d((Vec3i)emrs.getBlockPosition().internal()))).collect(Collectors.toList());
        if (!stocks.isEmpty()) {
            EntityMoveableRollingStock stock = (EntityMoveableRollingStock)stocks.get(0);
            return new Tuple((Object)stock.getUUID(), (Object)stock.getVelocity().internal());
        }
        return null;
    }
}

