/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.IngameListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class JoinGroupEntry
extends ListScreenEntryBase {
    protected static final ResourceLocation LOCK = new ResourceLocation("voicechat", "textures/icons/lock.png");
    protected static final ITextComponent GROUP_MEMBERS = new TextComponentTranslation("message.voicechat.group_members", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
    protected static final ITextComponent NO_GROUP_MEMBERS = new TextComponentTranslation("message.voicechat.no_group_members", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
    protected static final int SKIN_SIZE = 12;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = VoiceChatScreenBase.color(255, 74, 74, 74);
    protected static final int BG_FILL_SELECTED = VoiceChatScreenBase.color(255, 90, 90, 90);
    protected static final int PLAYER_NAME_COLOR = VoiceChatScreenBase.color(255, 255, 255, 255);
    protected final IngameListScreenBase parent;
    protected final Minecraft minecraft;
    protected final Group group;

    public JoinGroupEntry(IngameListScreenBase parent, Group group) {
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.group = group;
    }

    @Override
    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        if (isSelected) {
            GuiScreen.func_73734_a((int)x, (int)y, (int)(x + listWidth), (int)(y + slotHeight), (int)BG_FILL_SELECTED);
        } else {
            GuiScreen.func_73734_a((int)x, (int)y, (int)(x + listWidth), (int)(y + slotHeight), (int)BG_FILL);
        }
        boolean hasPassword = this.group.group.hasPassword();
        if (hasPassword) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + 4), (float)((float)y + (float)slotHeight / 2.0f - 8.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)1.3333334f, (float)1.3333334f, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(LOCK);
            GuiScreen.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (float)16.0f, (float)16.0f);
            GlStateManager.func_179121_F();
        }
        this.minecraft.field_71466_p.func_78276_b(this.group.group.getName(), x + 4 + (hasPassword ? 20 : 0), y + slotHeight / 2 - this.minecraft.field_71466_p.field_78288_b / 2, PLAYER_NAME_COLOR);
        int textWidth = this.minecraft.field_71466_p.func_78256_a(this.group.group.getName()) + (hasPassword ? 20 : 0);
        int headsPerRow = (listWidth - (4 + textWidth + 4 + 4)) / 13;
        int rows = 2;
        for (int i = 0; i < this.group.members.size(); ++i) {
            PlayerState state = (PlayerState)this.group.members.get(i);
            int headXIndex = i / rows;
            int headYIndex = i % rows;
            if (i >= headsPerRow * rows) break;
            int headPosX = x + listWidth - 12 - 4 - headXIndex * 13;
            int headPosY = y + slotHeight / 2 - 13 + 13 * headYIndex;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(GameProfileUtils.getSkin(state.getUuid()));
            GlStateManager.func_179109_b((float)headPosX, (float)headPosY, (float)0.0f);
            float scale = 1.5f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GuiScreen.func_146110_a((int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            GlStateManager.func_179147_l();
            GuiScreen.func_146110_a((int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (!isSelected) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        if (this.group.getGroup().getType().equals(Group.Type.NORMAL)) {
            tooltip.add(new TextComponentTranslation("message.voicechat.group_title", new Object[]{new TextComponentString(this.group.getGroup().getName())}).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("message.voicechat.group_type_title", new Object[]{new TextComponentString(this.group.getGroup().getName()), GroupType.fromType(this.group.getGroup().getType()).getTranslation()}).func_150254_d());
        }
        if (this.group.getMembers().isEmpty()) {
            tooltip.add(NO_GROUP_MEMBERS.func_150254_d());
        } else {
            tooltip.add(GROUP_MEMBERS.func_150254_d());
            int maxMembers = 10;
            for (int i = 0; i < this.group.getMembers().size(); ++i) {
                if (i >= maxMembers) {
                    tooltip.add(new TextComponentTranslation("message.voicechat.more_members", new Object[]{this.group.getMembers().size() - maxMembers}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d());
                    break;
                }
                PlayerState state = this.group.getMembers().get(i);
                tooltip.add(new TextComponentString("  " + state.getName()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d());
            }
        }
        this.parent.postRender(() -> this.parent.func_146283_a(tooltip, mouseX, mouseY));
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }

        public ClientGroup getGroup() {
            return this.group;
        }

        public List<PlayerState> getMembers() {
            return this.members;
        }
    }
}

