/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.plugins.CategoryManager;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ClientCategoryManager
extends CategoryManager {
    protected final Map<String, CustomTextureObject> images = new ConcurrentHashMap<String, CustomTextureObject>();

    public ClientCategoryManager() {
        CommonCompatibilityManager.INSTANCE.getNetManager().addCategoryChannel.setClientListener((client, handler, packet) -> {
            this.addCategory(packet.getCategory());
            Voicechat.LOGGER.debug("Added category {}", packet.getCategory().getId());
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().removeCategoryChannel.setClientListener((client, handler, packet) -> {
            this.removeCategory(packet.getCategoryId());
            Voicechat.LOGGER.debug("Removed category {}", packet.getCategoryId());
        });
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::clear);
    }

    @Override
    public void addCategory(VolumeCategoryImpl category) {
        super.addCategory(category);
        if (category.getIcon() != null) {
            this.registerImage(category.getId(), this.fromIntArray(category.getIcon()));
        }
        AdjustVolumeList.update();
    }

    @Override
    @Nullable
    public VolumeCategoryImpl removeCategory(String categoryId) {
        VolumeCategoryImpl volumeCategory = super.removeCategory(categoryId);
        this.unRegisterImage(categoryId);
        AdjustVolumeList.update();
        return volumeCategory;
    }

    public void clear() {
        this.categories.keySet().forEach(this::unRegisterImage);
        this.categories.clear();
    }

    private void registerImage(String id, BufferedImage image) {
        ResourceLocation resourceLocation = new ResourceLocation("voicechat", "category_" + id);
        this.images.put(id, new CustomTextureObject(resourceLocation, image));
    }

    private void unRegisterImage(String id) {
        CustomTextureObject customTextureObject = this.images.get(id);
        if (customTextureObject != null) {
            customTextureObject.func_147631_c();
            this.images.remove(id);
        }
    }

    private BufferedImage fromIntArray(int[][] icon) {
        if (icon.length != 16) {
            throw new IllegalStateException("Icon is not 16x16");
        }
        BufferedImage nativeImage = new BufferedImage(16, 16, 2);
        for (int x = 0; x < icon.length; ++x) {
            if (icon[x].length != 16) {
                throw new IllegalStateException("Icon is not 16x16");
            }
            for (int y = 0; y < icon.length; ++y) {
                nativeImage.setRGB(x, y, icon[x][y]);
            }
        }
        return nativeImage;
    }

    public ResourceLocation getTexture(String id, ResourceLocation defaultImage) {
        CustomTextureObject customTextureObject = this.images.get(id);
        if (customTextureObject == null) {
            return defaultImage;
        }
        return customTextureObject.getResourceLocation();
    }

    private static class CustomTextureObject
    extends SimpleTexture {
        private final BufferedImage image;
        private final ResourceLocation resourceLocation;

        public CustomTextureObject(ResourceLocation textureResourceLocation, BufferedImage image) {
            super(textureResourceLocation);
            this.resourceLocation = textureResourceLocation;
            this.image = image;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.image);
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

